function [residual, g1, g2, g3] = World_Economy_Cartel_Fracking_VD_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 80, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T36 = params(25)^(-1);
T39 = exp(y(22));
T63 = y(57)*(-exp(y(1)))+exp(y(1))*y(42)+T36*y(50)*(-(T39*exp(y(1))*exp(y(11))))+T36*y(53)*(-(exp(y(1))*T39))+T36*y(54)*(-(T39*exp(y(1))*exp(y(29))));
T79 = exp(y(25))+exp(y(2))+exp(y(3));
T80 = exp(y(2))/T79;
T89 = params(12)^(1-params(4));
T108 = exp(y(3))/T79;
T115 = params(13)^(1-params(4));
T153 = exp(y(1))*exp(y(4))-exp(y(4))*params(6)*exp(y(38)-y(24))^(params(5)-1);
T161 = exp(y(26))+exp(y(4))+exp(y(5));
T162 = exp(y(4))/T161;
T182 = exp(y(5))/T161;
T226 = exp(y(6))*y(60)+params(25)*y(46)*exp(y(6))*params(6)*exp(params(5)*y(10))+params(25)*y(60)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))))+params(25)*y(66)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
T249 = exp(y(7))*y(58)+params(25)*y(46)*exp(y(7))*params(6)*exp(y(11)*params(5))+params(25)*y(58)*(-(exp(y(7))*(1-exp(y(11)))))+params(25)*y(64)*(-(exp(y(11))*exp(y(7))));
T290 = params(25)*y(66)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(25)*y(46)*exp(y(6))*params(6)*params(5)*exp(params(5)*y(10))+params(25)*y(60)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
T312 = (-(T39*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*exp(y(11)*params(5)))));
T313 = y(50)*T312;
T362 = exp(y(16))^(1/params(2));
T364 = (-1)/params(2);
T366 = exp(y(15))*getPowerDeriv(exp(y(15)),T364,1);
T372 = (params(2)-1)/params(2);
T374 = exp(y(15))*getPowerDeriv(exp(y(15)),T372,1);
T384 = exp(y(17))^params(3);
T386 = exp(y(18))^(1-params(3));
T387 = T384*T386;
T388 = T387^T372;
T392 = (1-params(11))*exp(T372*y(23))*T388+params(11)*exp(y(15))^T372;
T394 = getPowerDeriv(T392,params(2)/(params(2)-1),1);
T407 = exp(y(17))^(params(3)-1);
T408 = T387^T364;
T412 = exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),1);
T421 = exp(y(18))^(-params(3));
T430 = exp(y(15))^T364;
T446 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3),1);
T448 = getPowerDeriv(T387,T372,1);
T450 = (1-params(11))*exp(T372*y(23))*T386*T446*T448;
T455 = T362*exp(T372*y(23))*(1-params(11))*(1-params(3));
T458 = getPowerDeriv(T387,T364,1);
T459 = T386*T446*T458;
T462 = T446*T408*T455+T384*T455*T459;
T468 = T362*exp(T372*y(23))*(1-params(11))*params(3);
T473 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,1);
T477 = (-(T386*(T407*T459*T468+T408*T468*T473)));
T503 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T506 = (-(params(9)*T503/(1+params(8))));
T507 = getPowerDeriv(T18,(-params(14)),1);
T508 = T506*T507;
T521 = (-(exp(T372*y(23))*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
T525 = exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),1);
T540 = exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),1);
T546 = (1-params(11))*exp(T372*y(23))*T448*T384*T525;
T594 = params(9)^((-1)/params(8));
T599 = exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),1);
T610 = T39*params(6)*params(5)*exp(y(11)*(params(5)-1))-T39*(exp(y(1))-y(13));
T625 = (-(T39*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)))));
T646 = (-(T39*(exp(y(1))*exp(y(29))+y(30)*(1-exp(y(29)))-params(22)*exp(y(29)*params(21)))));
T659 = T36*y(53)*T610+T39*y(49)+T36*y(48)*(-(T39*(1+exp(y(20))-params(10))))+T36*y(50)*T625+T36*y(51)*(-(y(14)*T39*(1-params(7))))+T36*y(54)*T646+T36*y(55)*(-(y(31)*T39*(1-params(23))));
T686 = T388*(1-params(11))*T372*exp(T372*y(23));
T693 = params(25)^2;
T704 = getPowerDeriv(exp(y(38)-y(24)),params(5)-1,1);
T720 = y(66)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(60)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
T724 = exp(y(25))/T79;
T729 = params(24)^(1-params(4));
T752 = exp(y(26))/T161;
T782 = exp(y(27))*y(59)+params(25)*y(46)*params(22)*exp(y(29)*params(21))*exp(y(27))+params(25)*y(59)*(-((1-exp(y(29)))*exp(y(27))))+params(25)*y(65)*(-(exp(y(29))*exp(y(27))));
T816 = (-(T39*(exp(y(1))*exp(y(29))+y(30)*(-exp(y(29)))-params(22)*params(21)*exp(y(29)*params(21)))));
T818 = T36*y(54)*T816;
residual(1) = T21*exp(y(1))*exp(y(4))+(-y(71))+T63+y(71)*params(25);
residual(2) = T21*(-exp(y(2)))+y(77)*(-T80)+(-y(73))+y(63)*(-(T89*params(4)*exp(y(2)*params(4))))+exp(y(2))*y(46)+params(25)*y(73)+params(25)*y(77)*T80;
residual(3) = y(77)*(-T108)+(-y(72))+y(61)*(-(T115*params(4)*exp(y(3)*params(4))))+y(52)*y(14)*T115*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+exp(y(3))*y(46)+params(25)*y(72)+params(25)*y(77)*T108;
residual(4) = T21*T153+y(78)*(-T162)+(-y(75))+y(67)*(-exp(y(4)))+exp(y(4))*y(66)+params(25)*y(75)+params(25)*y(78)*T162;
residual(5) = y(78)*(-T182)+(-y(74))+y(67)*(-exp(y(5)))+exp(y(5))*y(64)+params(25)*y(74)+params(25)*y(78)*T182;
residual(6) = T226;
residual(7) = T249;
residual(8) = y(63)*exp(y(8))+y(60)*(-(exp(y(8))*params(7)))+params(25)*y(63)*(-(exp(y(8))*(1-params(7))));
residual(9) = y(61)*exp(y(9))+y(58)*(-(params(7)*exp(y(9))))+params(25)*y(61)*(-((1-params(7))*exp(y(9))));
residual(10) = T290+params(25)*y(70)*(-exp(y(10)));
residual(11) = params(25)*y(64)*(-(exp(y(11))*exp(y(7))))+y(53)*T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T313+params(25)*y(46)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(25)*y(58)*(-(exp(y(7))*(-exp(y(11)))));
residual(12) = exp(y(12))*y(45);
residual(13) = y(51)*(-params(7))+y(50)+T36*y(50)*(-(T39*(1-exp(y(11)))))+T36*T39*y(53);
residual(14) = y(52)*T115*params(4)*exp(y(3)*(params(4)-1))+y(51)+T36*y(51)*(-(T39*(1-params(7))));
residual(15) = y(67)*exp(y(15))+y(42)*(-(params(11)*T362*T366))+y(41)*(-(params(11)*T374*T394));
residual(16) = (-y(76))+y(46)*(-exp(y(16)))+y(44)*(-(T386*T407*T408*exp(T372*y(23))*(1-params(11))*params(3)*T412))+y(43)*(-(T421*T384*T408*T412*exp(T372*y(23))*(1-params(11))*(1-params(3))))+y(42)*(-(T430*params(11)*T412))+exp(y(16))*y(41)+params(25)*y(76);
residual(17) = y(46)*exp(y(17))+params(25)*y(41)*(-(T394*T450))+params(25)*y(43)*(-(T421*T462))+params(25)*y(44)*T477+params(25)*y(45)*(-(exp(y(18)*(1-params(3)))*exp(T372*y(23))*params(3)*exp(y(17)*params(3))))+params(25)*y(46)*(-(exp(y(17))*(1-params(10))));
residual(18) = (T153-exp(y(2)))*T508+y(49)*(-(T508*params(1)/T21))+exp(y(18))*y(47)+y(45)*T521+y(44)*(-(T407*T408*T468*T525+T386*T407*T468*T458*T384*T525))+y(43)*(-(T421*T384*T455*T458*T384*T525+T384*T408*T455*T540))+y(41)*(-(T394*T546))+params(25)*y(49)*(-((-(T508*T21*params(1)))/(T21*T21)));
residual(19) = (T153-exp(y(2)))*exp(y(19))*T507+y(49)*(-(params(1)*exp(y(19))*T507/T21))+exp(y(19))*y(46)+params(25)*y(49)*(-((-(T21*params(1)*exp(y(19))*T507))/(T21*T21)));
residual(20) = y(44)*exp(y(20))+T36*y(48)*(-(T39*exp(y(20))));
residual(21) = y(47)*(-(T594*T599))+y(43)*exp(y(21));
residual(22) = T659;
residual(23) = y(69)+params(25)*y(69)*(-params(15))+y(45)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T372*exp(T372*y(23))))+y(44)*(-(T386*T407*T408*T362*(1-params(11))*params(3)*T372*exp(T372*y(23))))+y(43)*(-(T421*T384*T408*T362*(1-params(11))*(1-params(3))*T372*exp(T372*y(23))))+y(41)*(-(T394*T686))+T693*y(69)*(-params(16));
residual(24) = T21*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T704))+y(68)+T720;
residual(25) = y(77)*(-T724)+y(62)*(-(T729*params(4)*exp(y(25)*params(4))))+y(56)*y(31)*T729*params(4)*(params(4)-1)*exp(y(25)*(params(4)-1))+exp(y(25))*y(46)+params(25)*y(77)*T724;
residual(26) = y(78)*(-T752)+y(67)*(-exp(y(26)))+exp(y(26))*y(65)+params(25)*y(78)*T752;
residual(27) = T782;
residual(28) = y(62)*exp(y(28))+y(59)*(-(params(23)*exp(y(28))))+params(25)*y(62)*(-((1-params(23))*exp(y(28))));
residual(29) = y(65)*(-(exp(y(29))*exp(y(27))))+y(59)*(-(exp(y(27))*(-exp(y(29)))))+y(57)*params(22)*params(21)*(params(21)-1)*exp(y(29)*(params(21)-1))+y(46)*exp(y(27))*params(22)*params(21)*exp(y(29)*params(21))+T818;
residual(30) = y(57)+y(55)*(-params(23))+y(54)+T36*y(54)*(-(T39*(1-exp(y(29)))));
residual(31) = y(56)*T729*params(4)*exp(y(25)*(params(4)-1))+y(55)+T36*y(55)*(-(T39*(1-params(23))));
residual(32) = y(71);
residual(33) = y(72);
residual(34) = y(73);
residual(35) = y(74);
residual(36) = y(75);
residual(37) = y(76);
residual(38) = T21*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T704))+y(70)*exp(y(38));
residual(39) = y(77);
residual(40) = y(78);
residual(41) = exp(y(16))-T392^(params(2)/(params(2)-1));
residual(42) = exp(y(1))-params(11)*T362*T430;
residual(43) = exp(y(21))-T421*T384*T408*T455;
residual(44) = exp(y(20))-T386*T407*T408*T468;
residual(45) = exp(y(12))-exp(y(18)*(1-params(3)))*exp(T372*y(23))*exp(y(17)*params(3));
residual(46) = exp(y(6))*params(6)*exp(params(5)*y(10))+params(22)*exp(y(29)*params(21))*exp(y(27))+exp(y(7))*params(6)*exp(y(11)*params(5))+exp(y(25))+exp(y(2))+exp(y(3))+exp(y(19))+exp(y(17))-(exp(y(16))+exp(y(17))*(1-params(10)));
residual(47) = exp(y(18))-T594*exp(y(21))^(1/params(8));
residual(48) = 1-T39*(1+exp(y(20))-params(10));
residual(49) = T39-T21*params(1)/T21;
residual(50) = y(13)-T39*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)));
residual(51) = y(14)-(y(14)*T39*(1-params(7))+params(7)*y(13));
residual(52) = y(14)*T115*params(4)*exp(y(3)*(params(4)-1))-1;
residual(53) = T610;
residual(54) = y(30)-T39*(exp(y(1))*exp(y(29))+y(30)*(1-exp(y(29)))-params(22)*exp(y(29)*params(21)));
residual(55) = y(31)-(y(31)*T39*(1-params(23))+y(30)*params(23));
residual(56) = y(31)*T729*params(4)*exp(y(25)*(params(4)-1))-1;
residual(57) = params(22)*params(21)*exp(y(29)*(params(21)-1))-(exp(y(1))-y(30));
residual(58) = exp(y(7))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9)));
residual(59) = exp(y(27))-((1-exp(y(29)))*exp(y(27))+params(23)*exp(y(28)));
residual(60) = exp(y(6))-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))+exp(y(8))*params(7));
residual(61) = exp(y(9))-((1-params(7))*exp(y(9))+T115*exp(y(3)*params(4)));
residual(62) = exp(y(28))-((1-params(23))*exp(y(28))+T729*exp(y(25)*params(4)));
residual(63) = exp(y(8))-(exp(y(8))*(1-params(7))+T89*exp(y(2)*params(4)));
residual(64) = exp(y(5))-exp(y(11))*exp(y(7));
residual(65) = exp(y(26))-exp(y(29))*exp(y(27));
residual(66) = exp(y(4))-exp(y(6))*exp((-y(24)))*exp(y(10));
residual(67) = exp(y(15))-T161;
residual(68) = y(24)-x(1);
residual(69) = y(23)-(x(2)+y(23)*params(15)+y(23)*params(16));
residual(70) = exp(y(38))-exp(y(10));
residual(71) = y(32);
residual(72) = y(33);
residual(73) = y(34);
residual(74) = y(35);
residual(75) = y(36);
residual(76) = y(37);
residual(77) = y(39);
residual(78) = y(40);
lhs =y(79);
rhs =y(69);
residual(79)= lhs-rhs;
lhs =y(80);
rhs =y(23);
residual(80)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(80, 80);

  %
  % Jacobian matrix
  %

T1005 = T36*y(54)*(-(T39*exp(y(1))*exp(y(29))))+T36*y(50)*(-(T39*exp(y(1))*exp(y(11))))+T36*y(53)*(-(exp(y(1))*T39));
T1010 = (exp(y(2))*T79-exp(y(2))*exp(y(2)))/(T79*T79);
T1030 = y(77)*(-((-(exp(y(2))*exp(y(3))))/(T79*T79)))+params(25)*y(77)*(-(exp(y(2))*exp(y(3))))/(T79*T79);
T1040 = y(77)*(-((-(exp(y(2))*exp(y(25))))/(T79*T79)))+params(25)*y(77)*(-(exp(y(2))*exp(y(25))))/(T79*T79);
T1044 = (exp(y(3))*T79-exp(y(3))*exp(y(3)))/(T79*T79);
T1070 = y(77)*(-((-(exp(y(25))*exp(y(3))))/(T79*T79)))+params(25)*y(77)*(-(exp(y(25))*exp(y(3))))/(T79*T79);
T1075 = (exp(y(4))*T161-exp(y(4))*exp(y(4)))/(T161*T161);
T1090 = y(78)*(-((-(exp(y(4))*exp(y(5))))/(T161*T161)))+params(25)*y(78)*(-(exp(y(4))*exp(y(5))))/(T161*T161);
T1100 = y(78)*(-((-(exp(y(4))*exp(y(26))))/(T161*T161)))+params(25)*y(78)*(-(exp(y(4))*exp(y(26))))/(T161*T161);
T1104 = (exp(y(5))*T161-exp(y(5))*exp(y(5)))/(T161*T161);
T1118 = y(78)*(-((-(exp(y(26))*exp(y(5))))/(T161*T161)))+params(25)*y(78)*(-(exp(y(26))*exp(y(5))))/(T161*T161);
T1121 = params(25)*y(64)*(-(exp(y(11))*exp(y(7))))+params(25)*y(46)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(25)*y(58)*(-(exp(y(7))*(-exp(y(11)))));
T1173 = getPowerDeriv(T392,params(2)/(params(2)-1),2);
T1198 = T412+exp(y(16))*exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),2);
T1225 = y(43)*(-(T421*(T408*T412*exp(T372*y(23))*(1-params(11))*(1-params(3))*T446+T384*T412*exp(T372*y(23))*(1-params(11))*(1-params(3))*T459)));
T1233 = y(44)*(-(T386*(T407*exp(T372*y(23))*(1-params(11))*params(3)*T412*T459+T408*exp(T372*y(23))*(1-params(11))*params(3)*T412*T473)));
T1250 = y(44)*(-(T407*T408*exp(T372*y(23))*(1-params(11))*params(3)*T412*T525+T386*T407*exp(T372*y(23))*(1-params(11))*params(3)*T412*T458*T384*T525))+y(43)*(-(T421*T384*T412*exp(T372*y(23))*(1-params(11))*(1-params(3))*T458*T384*T525+T384*T408*T412*exp(T372*y(23))*(1-params(11))*(1-params(3))*T540));
T1263 = y(44)*(-(T386*T407*T408*T412*(1-params(11))*params(3)*T372*exp(T372*y(23))))+y(43)*(-(T421*T384*T408*T412*(1-params(11))*(1-params(3))*T372*exp(T372*y(23))));
T1272 = T446+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3),2);
T1274 = getPowerDeriv(T387,T372,2);
T1289 = getPowerDeriv(T387,T364,2);
T1293 = T458*T386*T1272+T386*T446*T386*T446*T1289;
T1375 = y(44)*(-(T386*(T473*T408*T362*(1-params(11))*params(3)*T372*exp(T372*y(23))+T407*T459*T362*(1-params(11))*params(3)*T372*exp(T372*y(23)))));
T1382 = y(43)*(-(T421*(T446*T408*T362*(1-params(11))*(1-params(3))*T372*exp(T372*y(23))+T384*T459*T362*(1-params(11))*(1-params(3))*T372*exp(T372*y(23)))));
T1437 = getPowerDeriv(T18,(-params(14)),2);
T1441 = T507*(-(params(9)*(T503+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2))/(1+params(8))))+T506*T506*T1437;
T1457 = T525+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),2);
T1546 = y(44)*(-(T525*T407*T408*T362*(1-params(11))*params(3)*T372*exp(T372*y(23))+T386*T407*T458*T384*T525*T362*(1-params(11))*params(3)*T372*exp(T372*y(23))));
T1553 = y(43)*(-(T540*T384*T408*T362*(1-params(11))*(1-params(3))*T372*exp(T372*y(23))+T421*T384*T458*T384*T525*T362*(1-params(11))*(1-params(3))*T372*exp(T372*y(23))));
T1685 = params(25)*y(60)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(25)*y(66)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
T1686 = getPowerDeriv(exp(y(38)-y(24)),params(5)-1,2);
T1705 = (exp(y(25))*T79-exp(y(25))*exp(y(25)))/(T79*T79);
T1727 = (exp(y(26))*T161-exp(y(26))*exp(y(26)))/(T161*T161);
  g1(1,1)=T21*exp(y(1))*exp(y(4))+T63;
  g1(1,4)=T21*exp(y(1))*exp(y(4));
  g1(1,11)=T36*y(50)*(-(T39*exp(y(1))*exp(y(11))));
  g1(1,18)=exp(y(1))*exp(y(4))*T508;
  g1(1,19)=exp(y(1))*exp(y(4))*exp(y(19))*T507;
  g1(1,22)=T1005;
  g1(1,29)=T36*y(54)*(-(T39*exp(y(1))*exp(y(29))));
  g1(1,42)=exp(y(1));
  g1(1,50)=T36*(-(T39*exp(y(1))*exp(y(11))));
  g1(1,53)=T36*(-(exp(y(1))*T39));
  g1(1,54)=T36*(-(T39*exp(y(1))*exp(y(29))));
  g1(1,57)=(-exp(y(1)));
  g1(1,71)=(-1)+params(25);
  g1(2,2)=T21*(-exp(y(2)))+y(77)*(-T1010)+exp(y(2))*y(46)+y(63)*(-(T89*params(4)*params(4)*exp(y(2)*params(4))))+params(25)*y(77)*T1010;
  g1(2,3)=T1030;
  g1(2,18)=(-exp(y(2)))*T508;
  g1(2,19)=(-exp(y(2)))*exp(y(19))*T507;
  g1(2,25)=T1040;
  g1(2,46)=exp(y(2));
  g1(2,63)=(-(T89*params(4)*exp(y(2)*params(4))));
  g1(2,73)=(-1)+params(25);
  g1(2,77)=(-T80)+params(25)*T80;
  g1(3,2)=T1030;
  g1(3,3)=y(77)*(-T1044)+y(61)*(-(T115*params(4)*params(4)*exp(y(3)*params(4))))+exp(y(3))*y(46)+y(52)*y(14)*T115*params(4)*(params(4)-1)*(params(4)-1)*exp(y(3)*(params(4)-1))+params(25)*y(77)*T1044;
  g1(3,14)=y(52)*T115*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,25)=T1070;
  g1(3,46)=exp(y(3));
  g1(3,52)=y(14)*T115*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,61)=(-(T115*params(4)*exp(y(3)*params(4))));
  g1(3,72)=(-1)+params(25);
  g1(3,77)=(-T108)+params(25)*T108;
  g1(4,1)=T21*exp(y(1))*exp(y(4));
  g1(4,4)=T21*T153+y(78)*(-T1075)+y(67)*(-exp(y(4)))+exp(y(4))*y(66)+params(25)*y(78)*T1075;
  g1(4,5)=T1090;
  g1(4,18)=T153*T508;
  g1(4,19)=T153*exp(y(19))*T507;
  g1(4,24)=T21*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T704));
  g1(4,26)=T1100;
  g1(4,38)=T21*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T704));
  g1(4,66)=exp(y(4));
  g1(4,67)=(-exp(y(4)));
  g1(4,75)=(-1)+params(25);
  g1(4,78)=(-T162)+params(25)*T162;
  g1(5,4)=T1090;
  g1(5,5)=y(78)*(-T1104)+y(67)*(-exp(y(5)))+exp(y(5))*y(64)+params(25)*y(78)*T1104;
  g1(5,26)=T1118;
  g1(5,64)=exp(y(5));
  g1(5,67)=(-exp(y(5)));
  g1(5,74)=(-1)+params(25);
  g1(5,78)=(-T182)+params(25)*T182;
  g1(6,6)=T226;
  g1(6,10)=T290;
  g1(6,24)=T1685;
  g1(6,46)=params(25)*exp(y(6))*params(6)*exp(params(5)*y(10));
  g1(6,60)=exp(y(6))+params(25)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))));
  g1(6,66)=params(25)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(7,7)=T249;
  g1(7,11)=T1121;
  g1(7,46)=params(25)*exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(7,58)=exp(y(7))+params(25)*(-(exp(y(7))*(1-exp(y(11)))));
  g1(7,64)=params(25)*(-(exp(y(11))*exp(y(7))));
  g1(8,8)=y(63)*exp(y(8))+y(60)*(-(exp(y(8))*params(7)))+params(25)*y(63)*(-(exp(y(8))*(1-params(7))));
  g1(8,60)=(-(exp(y(8))*params(7)));
  g1(8,63)=exp(y(8))+params(25)*(-(exp(y(8))*(1-params(7))));
  g1(9,9)=y(61)*exp(y(9))+y(58)*(-(params(7)*exp(y(9))))+params(25)*y(61)*(-((1-params(7))*exp(y(9))));
  g1(9,58)=(-(params(7)*exp(y(9))));
  g1(9,61)=exp(y(9))+params(25)*(-((1-params(7))*exp(y(9))));
  g1(10,6)=T290;
  g1(10,10)=params(25)*y(70)*(-exp(y(10)))+params(25)*y(66)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(25)*y(60)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+params(25)*y(46)*exp(y(6))*params(6)*params(5)*params(5)*exp(params(5)*y(10));
  g1(10,24)=T1685;
  g1(10,46)=params(25)*exp(y(6))*params(6)*params(5)*exp(params(5)*y(10));
  g1(10,60)=params(25)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(10,66)=params(25)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(10,70)=params(25)*(-exp(y(10)));
  g1(11,1)=y(50)*(-(T39*exp(y(1))*exp(y(11))));
  g1(11,7)=T1121;
  g1(11,11)=params(25)*y(64)*(-(exp(y(11))*exp(y(7))))+params(25)*y(58)*(-(exp(y(7))*(-exp(y(11)))))+y(53)*T39*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(11)*(params(5)-1))+y(50)*(-(T39*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*params(5)*exp(y(11)*params(5)))))+params(25)*y(46)*exp(y(7))*params(6)*params(5)*params(5)*exp(y(11)*params(5));
  g1(11,13)=y(50)*(-(T39*(-exp(y(11)))));
  g1(11,22)=y(53)*T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T313;
  g1(11,46)=params(25)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(11,50)=T312;
  g1(11,53)=T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(11,58)=params(25)*(-(exp(y(7))*(-exp(y(11)))));
  g1(11,64)=params(25)*(-(exp(y(11))*exp(y(7))));
  g1(12,12)=exp(y(12))*y(45);
  g1(12,45)=exp(y(12));
  g1(13,11)=T36*y(50)*(-(T39*(-exp(y(11)))));
  g1(13,22)=T36*y(50)*(-(T39*(1-exp(y(11)))))+T36*T39*y(53);
  g1(13,50)=1+T36*(-(T39*(1-exp(y(11)))));
  g1(13,51)=(-params(7));
  g1(13,53)=T36*T39;
  g1(14,3)=y(52)*T115*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(14,22)=T36*y(51)*(-(T39*(1-params(7))));
  g1(14,51)=1+T36*(-(T39*(1-params(7))));
  g1(14,52)=T115*params(4)*exp(y(3)*(params(4)-1));
  g1(15,15)=y(67)*exp(y(15))+y(42)*(-(params(11)*T362*(T366+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T364,2))))+y(41)*(-(T394*params(11)*(T374+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T372,2))+params(11)*T374*params(11)*T374*T1173));
  g1(15,16)=y(42)*(-(T366*params(11)*T412));
  g1(15,17)=y(41)*(-(params(11)*T374*T450*T1173));
  g1(15,18)=y(41)*(-(params(11)*T374*T546*T1173));
  g1(15,23)=y(41)*(-(params(11)*T374*T686*T1173));
  g1(15,41)=(-(params(11)*T374*T394));
  g1(15,42)=(-(params(11)*T362*T366));
  g1(15,67)=exp(y(15));
  g1(16,15)=y(42)*(-(T366*params(11)*T412));
  g1(16,16)=y(46)*(-exp(y(16)))+y(44)*(-(T386*T407*T408*exp(T372*y(23))*(1-params(11))*params(3)*T1198))+y(43)*(-(T421*T384*T408*exp(T372*y(23))*(1-params(11))*(1-params(3))*T1198))+exp(y(16))*y(41)+y(42)*(-(T430*params(11)*T1198));
  g1(16,17)=T1225+T1233;
  g1(16,18)=T1250;
  g1(16,23)=T1263;
  g1(16,41)=exp(y(16));
  g1(16,42)=(-(T430*params(11)*T412));
  g1(16,43)=(-(T421*T384*T408*T412*exp(T372*y(23))*(1-params(11))*(1-params(3))));
  g1(16,44)=(-(T386*T407*T408*exp(T372*y(23))*(1-params(11))*params(3)*T412));
  g1(16,46)=(-exp(y(16)));
  g1(16,76)=(-1)+params(25);
  g1(17,15)=params(25)*y(41)*(-(T450*params(11)*T374*T1173));
  g1(17,16)=params(25)*T1225+params(25)*T1233;
  g1(17,17)=y(46)*exp(y(17))+params(25)*y(46)*(-(exp(y(17))*(1-params(10))))+params(25)*y(41)*(-(T450*T450*T1173+T394*(1-params(11))*exp(T372*y(23))*(T448*T386*T1272+T386*T446*T386*T446*T1274)))+params(25)*y(43)*(-(T421*(T408*T455*T1272+T446*T455*T459+T446*T455*T459+T384*T455*T1293)))+params(25)*y(44)*(-(T386*(T459*T468*T473+T407*T468*T1293+T459*T468*T473+T408*T468*(T473+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,2)))))+params(25)*y(45)*(-(exp(y(18)*(1-params(3)))*exp(T372*y(23))*params(3)*params(3)*exp(y(17)*params(3))));
  g1(17,18)=params(25)*y(41)*(-(T450*T546*T1173+T394*(1-params(11))*exp(T372*y(23))*(T448*T446*T525+T386*T446*T384*T525*T1274)))+params(25)*y(43)*(-(T462*T540+T421*(T446*T455*T458*T384*T525+T384*T455*(T458*T446*T525+T386*T446*T384*T525*T1289))))+params(25)*y(44)*(-((T407*T459*T468+T408*T468*T473)*T525+T386*(T473*T468*T458*T384*T525+T407*T468*(T458*T446*T525+T386*T446*T384*T525*T1289))))+params(25)*y(45)*(-(exp(T372*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
  g1(17,23)=params(25)*y(41)*(-(T394*T386*T446*T448*(1-params(11))*T372*exp(T372*y(23))+T450*T686*T1173))+params(25)*T1382+params(25)*T1375+params(25)*y(45)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T372*exp(T372*y(23))));
  g1(17,41)=params(25)*(-(T394*T450));
  g1(17,43)=params(25)*(-(T421*T462));
  g1(17,44)=params(25)*T477;
  g1(17,45)=params(25)*(-(exp(y(18)*(1-params(3)))*exp(T372*y(23))*params(3)*exp(y(17)*params(3))));
  g1(17,46)=exp(y(17))+params(25)*(-(exp(y(17))*(1-params(10))));
  g1(18,1)=exp(y(1))*exp(y(4))*T508;
  g1(18,2)=(-exp(y(2)))*T508;
  g1(18,4)=T153*T508;
  g1(18,15)=y(41)*(-(T546*params(11)*T374*T1173));
  g1(18,16)=T1250;
  g1(18,17)=y(45)*(-(exp(T372*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(44)*(-((T407*T459*T468+T408*T468*T473)*T525+T386*(T473*T468*T458*T384*T525+T407*T468*(T384*T525*T386*T446*T1289+T458*T446*T525))))+y(43)*(-(T421*(T446*T455*T458*T384*T525+T384*T455*(T384*T525*T386*T446*T1289+T458*T446*T525))+T462*T540))+y(41)*(-(T546*T450*T1173+T394*(1-params(11))*exp(T372*y(23))*(T384*T525*T386*T446*T1274+T448*T446*T525)));
  g1(18,18)=(T153-exp(y(2)))*T1441+y(49)*(-((T21*params(1)*T1441-T508*T508*params(1))/(T21*T21)))+exp(y(18))*y(47)+y(45)*(-(exp(T372*y(23))*exp(y(17)*params(3))*(1-params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(44)*(-(T525*T407*T468*T458*T384*T525+T407*T408*T468*T1457+T525*T407*T468*T458*T384*T525+T386*T407*T468*(T384*T525*T384*T525*T1289+T458*T384*T1457)))+y(43)*(-(T384*T455*T458*T384*T525*T540+T421*T384*T455*(T384*T525*T384*T525*T1289+T458*T384*T1457)+T384*T455*T458*T384*T525*T540+T384*T408*T455*(T540+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),2))))+y(41)*(-(T546*T546*T1173+T394*(1-params(11))*exp(T372*y(23))*(T384*T525*T384*T525*T1274+T448*T384*T1457)))+params(25)*y(49)*(-((T21*T21*(-(T508*T508*params(1)+T21*params(1)*T1441))-(-(T508*T21*params(1)))*(T21*T508+T21*T508))/(T21*T21*T21*T21)));
  g1(18,19)=(T153-exp(y(2)))*T506*exp(y(19))*T1437+y(49)*(-((T21*params(1)*T506*exp(y(19))*T1437-T508*params(1)*exp(y(19))*T507)/(T21*T21)))+params(25)*y(49)*(-((T21*T21*(-(T508*params(1)*exp(y(19))*T507+T21*params(1)*T506*exp(y(19))*T1437))-(-(T508*T21*params(1)))*(T21*exp(y(19))*T507+T21*exp(y(19))*T507))/(T21*T21*T21*T21)));
  g1(18,23)=y(45)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T372*exp(T372*y(23))))+T1546+T1553+y(41)*(-(T394*T448*T384*T525*(1-params(11))*T372*exp(T372*y(23))+T546*T686*T1173));
  g1(18,24)=T508*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T704));
  g1(18,38)=T508*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T704));
  g1(18,41)=(-(T394*T546));
  g1(18,43)=(-(T421*T384*T455*T458*T384*T525+T384*T408*T455*T540));
  g1(18,44)=(-(T407*T408*T468*T525+T386*T407*T468*T458*T384*T525));
  g1(18,45)=T521;
  g1(18,47)=exp(y(18));
  g1(18,49)=(-(T508*params(1)/T21))+params(25)*(-((-(T508*T21*params(1)))/(T21*T21)));
  g1(19,1)=exp(y(1))*exp(y(4))*exp(y(19))*T507;
  g1(19,2)=(-exp(y(2)))*exp(y(19))*T507;
  g1(19,4)=T153*exp(y(19))*T507;
  g1(19,18)=(T153-exp(y(2)))*exp(y(19))*T506*T1437+y(49)*(-((T21*params(1)*exp(y(19))*T506*T1437-T508*params(1)*exp(y(19))*T507)/(T21*T21)))+params(25)*y(49)*(-((T21*T21*(-(T508*params(1)*exp(y(19))*T507+T21*params(1)*exp(y(19))*T506*T1437))-(-(T21*params(1)*exp(y(19))*T507))*(T21*T508+T21*T508))/(T21*T21*T21*T21)));
  g1(19,19)=(T153-exp(y(2)))*(exp(y(19))*T507+exp(y(19))*exp(y(19))*T1437)+y(49)*(-((T21*params(1)*(exp(y(19))*T507+exp(y(19))*exp(y(19))*T1437)-exp(y(19))*T507*params(1)*exp(y(19))*T507)/(T21*T21)))+exp(y(19))*y(46)+params(25)*y(49)*(-((T21*T21*(-(exp(y(19))*T507*params(1)*exp(y(19))*T507+T21*params(1)*(exp(y(19))*T507+exp(y(19))*exp(y(19))*T1437)))-(-(T21*params(1)*exp(y(19))*T507))*(T21*exp(y(19))*T507+T21*exp(y(19))*T507))/(T21*T21*T21*T21)));
  g1(19,24)=exp(y(19))*T507*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T704));
  g1(19,38)=exp(y(19))*T507*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T704));
  g1(19,46)=exp(y(19));
  g1(19,49)=(-(params(1)*exp(y(19))*T507/T21))+params(25)*(-((-(T21*params(1)*exp(y(19))*T507))/(T21*T21)));
  g1(20,20)=y(44)*exp(y(20))+T36*y(48)*(-(T39*exp(y(20))));
  g1(20,22)=T36*y(48)*(-(T39*exp(y(20))));
  g1(20,44)=exp(y(20));
  g1(20,48)=T36*(-(T39*exp(y(20))));
  g1(21,21)=y(43)*exp(y(21))+y(47)*(-(T594*(T599+exp(y(21))*exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),2))));
  g1(21,43)=exp(y(21));
  g1(21,47)=(-(T594*T599));
  g1(22,1)=T1005;
  g1(22,11)=T36*y(53)*T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T36*T313;
  g1(22,13)=T36*y(50)*(-(T39*(1-exp(y(11)))))+T36*T39*y(53);
  g1(22,14)=T36*y(51)*(-(T39*(1-params(7))));
  g1(22,20)=T36*y(48)*(-(T39*exp(y(20))));
  g1(22,22)=T659;
  g1(22,29)=T818;
  g1(22,30)=T36*y(54)*(-(T39*(1-exp(y(29)))));
  g1(22,31)=T36*y(55)*(-(T39*(1-params(23))));
  g1(22,48)=T36*(-(T39*(1+exp(y(20))-params(10))));
  g1(22,49)=T39;
  g1(22,50)=T36*T625;
  g1(22,51)=T36*(-(y(14)*T39*(1-params(7))));
  g1(22,53)=T36*T610;
  g1(22,54)=T36*T646;
  g1(22,55)=T36*(-(y(31)*T39*(1-params(23))));
  g1(23,15)=y(41)*(-(T686*params(11)*T374*T1173));
  g1(23,16)=T1263;
  g1(23,17)=y(45)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T372*exp(T372*y(23))))+T1375+T1382+y(41)*(-(T686*T450*T1173+T394*T386*T446*T448*(1-params(11))*T372*exp(T372*y(23))));
  g1(23,18)=y(45)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T372*exp(T372*y(23))))+T1546+T1553+y(41)*(-(T686*T546*T1173+T394*T448*T384*T525*(1-params(11))*T372*exp(T372*y(23))));
  g1(23,23)=y(45)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T372*T372*exp(T372*y(23))))+y(44)*(-(T386*T407*T408*T362*(1-params(11))*params(3)*T372*T372*exp(T372*y(23))))+y(43)*(-(T421*T384*T408*T362*(1-params(11))*(1-params(3))*T372*T372*exp(T372*y(23))))+y(41)*(-(T686*T686*T1173+T394*T388*(1-params(11))*T372*T372*exp(T372*y(23))));
  g1(23,41)=(-(T394*T686));
  g1(23,43)=(-(T421*T384*T408*T362*(1-params(11))*(1-params(3))*T372*exp(T372*y(23))));
  g1(23,44)=(-(T386*T407*T408*T362*(1-params(11))*params(3)*T372*exp(T372*y(23))));
  g1(23,45)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T372*exp(T372*y(23))));
  g1(23,69)=1+params(25)*(-params(15))+T693*(-params(16));
  g1(24,4)=T21*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T704));
  g1(24,6)=T720;
  g1(24,10)=T720;
  g1(24,18)=T508*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T704));
  g1(24,19)=exp(y(19))*T507*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T704));
  g1(24,24)=T21*(-(exp(y(4))*params(6)*(exp(y(38)-y(24))*T704+(-exp(y(38)-y(24)))*(-exp(y(38)-y(24)))*T1686)))+y(66)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+y(60)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(24,38)=T21*(-(exp(y(4))*params(6)*((-exp(y(38)-y(24)))*T704+(-exp(y(38)-y(24)))*exp(y(38)-y(24))*T1686)));
  g1(24,60)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(24,66)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(24,68)=1;
  g1(25,2)=T1040;
  g1(25,3)=T1070;
  g1(25,25)=y(77)*(-T1705)+y(62)*(-(T729*params(4)*params(4)*exp(y(25)*params(4))))+exp(y(25))*y(46)+y(56)*y(31)*T729*params(4)*(params(4)-1)*(params(4)-1)*exp(y(25)*(params(4)-1))+params(25)*y(77)*T1705;
  g1(25,31)=y(56)*T729*params(4)*(params(4)-1)*exp(y(25)*(params(4)-1));
  g1(25,46)=exp(y(25));
  g1(25,56)=y(31)*T729*params(4)*(params(4)-1)*exp(y(25)*(params(4)-1));
  g1(25,62)=(-(T729*params(4)*exp(y(25)*params(4))));
  g1(25,77)=(-T724)+params(25)*T724;
  g1(26,4)=T1100;
  g1(26,5)=T1118;
  g1(26,26)=y(78)*(-T1727)+y(67)*(-exp(y(26)))+exp(y(26))*y(65)+params(25)*y(78)*T1727;
  g1(26,65)=exp(y(26));
  g1(26,67)=(-exp(y(26)));
  g1(26,78)=(-T752)+params(25)*T752;
  g1(27,27)=T782;
  g1(27,29)=params(25)*y(65)*(-(exp(y(29))*exp(y(27))))+params(25)*y(46)*exp(y(27))*params(22)*params(21)*exp(y(29)*params(21))+params(25)*y(59)*(-(exp(y(27))*(-exp(y(29)))));
  g1(27,46)=params(25)*params(22)*exp(y(29)*params(21))*exp(y(27));
  g1(27,59)=exp(y(27))+params(25)*(-((1-exp(y(29)))*exp(y(27))));
  g1(27,65)=params(25)*(-(exp(y(29))*exp(y(27))));
  g1(28,28)=y(62)*exp(y(28))+y(59)*(-(params(23)*exp(y(28))))+params(25)*y(62)*(-((1-params(23))*exp(y(28))));
  g1(28,59)=(-(params(23)*exp(y(28))));
  g1(28,62)=exp(y(28))+params(25)*(-((1-params(23))*exp(y(28))));
  g1(29,1)=T36*y(54)*(-(T39*exp(y(1))*exp(y(29))));
  g1(29,22)=T818;
  g1(29,27)=y(65)*(-(exp(y(29))*exp(y(27))))+y(59)*(-(exp(y(27))*(-exp(y(29)))))+y(46)*exp(y(27))*params(22)*params(21)*exp(y(29)*params(21));
  g1(29,29)=y(65)*(-(exp(y(29))*exp(y(27))))+y(59)*(-(exp(y(27))*(-exp(y(29)))))+y(57)*params(22)*params(21)*(params(21)-1)*(params(21)-1)*exp(y(29)*(params(21)-1))+y(46)*exp(y(27))*params(22)*params(21)*params(21)*exp(y(29)*params(21))+T36*y(54)*(-(T39*(exp(y(1))*exp(y(29))+y(30)*(-exp(y(29)))-params(22)*params(21)*params(21)*exp(y(29)*params(21)))));
  g1(29,30)=T36*y(54)*(-(T39*(-exp(y(29)))));
  g1(29,46)=exp(y(27))*params(22)*params(21)*exp(y(29)*params(21));
  g1(29,54)=T36*T816;
  g1(29,57)=params(22)*params(21)*(params(21)-1)*exp(y(29)*(params(21)-1));
  g1(29,59)=(-(exp(y(27))*(-exp(y(29)))));
  g1(29,65)=(-(exp(y(29))*exp(y(27))));
  g1(30,22)=T36*y(54)*(-(T39*(1-exp(y(29)))));
  g1(30,29)=T36*y(54)*(-(T39*(-exp(y(29)))));
  g1(30,54)=1+T36*(-(T39*(1-exp(y(29)))));
  g1(30,55)=(-params(23));
  g1(30,57)=1;
  g1(31,22)=T36*y(55)*(-(T39*(1-params(23))));
  g1(31,25)=y(56)*T729*params(4)*(params(4)-1)*exp(y(25)*(params(4)-1));
  g1(31,55)=1+T36*(-(T39*(1-params(23))));
  g1(31,56)=T729*params(4)*exp(y(25)*(params(4)-1));
  g1(32,71)=1;
  g1(33,72)=1;
  g1(34,73)=1;
  g1(35,74)=1;
  g1(36,75)=1;
  g1(37,76)=1;
  g1(38,4)=T21*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T704));
  g1(38,18)=T508*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T704));
  g1(38,19)=exp(y(19))*T507*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T704));
  g1(38,24)=T21*(-(exp(y(4))*params(6)*((-exp(y(38)-y(24)))*T704+exp(y(38)-y(24))*(-exp(y(38)-y(24)))*T1686)));
  g1(38,38)=y(70)*exp(y(38))+T21*(-(exp(y(4))*params(6)*(exp(y(38)-y(24))*T704+exp(y(38)-y(24))*exp(y(38)-y(24))*T1686)));
  g1(38,70)=exp(y(38));
  g1(39,77)=1;
  g1(40,78)=1;
  g1(41,15)=(-(params(11)*T374*T394));
  g1(41,16)=exp(y(16));
  g1(41,17)=(-(T394*T450));
  g1(41,18)=(-(T394*T546));
  g1(41,23)=(-(T394*T686));
  g1(42,1)=exp(y(1));
  g1(42,15)=(-(params(11)*T362*T366));
  g1(42,16)=(-(T430*params(11)*T412));
  g1(43,16)=(-(T421*T384*T408*T412*exp(T372*y(23))*(1-params(11))*(1-params(3))));
  g1(43,17)=(-(T421*T462));
  g1(43,18)=(-(T421*T384*T455*T458*T384*T525+T384*T408*T455*T540));
  g1(43,21)=exp(y(21));
  g1(43,23)=(-(T421*T384*T408*T362*(1-params(11))*(1-params(3))*T372*exp(T372*y(23))));
  g1(44,16)=(-(T386*T407*T408*exp(T372*y(23))*(1-params(11))*params(3)*T412));
  g1(44,17)=T477;
  g1(44,18)=(-(T407*T408*T468*T525+T386*T407*T468*T458*T384*T525));
  g1(44,20)=exp(y(20));
  g1(44,23)=(-(T386*T407*T408*T362*(1-params(11))*params(3)*T372*exp(T372*y(23))));
  g1(45,12)=exp(y(12));
  g1(45,17)=(-(exp(y(18)*(1-params(3)))*exp(T372*y(23))*params(3)*exp(y(17)*params(3))));
  g1(45,18)=T521;
  g1(45,23)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T372*exp(T372*y(23))));
  g1(46,2)=exp(y(2));
  g1(46,3)=exp(y(3));
  g1(46,6)=exp(y(6))*params(6)*exp(params(5)*y(10));
  g1(46,7)=exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(46,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*y(10));
  g1(46,11)=exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(46,16)=(-exp(y(16)));
  g1(46,17)=exp(y(17))-exp(y(17))*(1-params(10));
  g1(46,19)=exp(y(19));
  g1(46,25)=exp(y(25));
  g1(46,27)=params(22)*exp(y(29)*params(21))*exp(y(27));
  g1(46,29)=exp(y(27))*params(22)*params(21)*exp(y(29)*params(21));
  g1(47,18)=exp(y(18));
  g1(47,21)=(-(T594*T599));
  g1(48,20)=(-(T39*exp(y(20))));
  g1(48,22)=(-(T39*(1+exp(y(20))-params(10))));
  g1(49,18)=(-((T21*T508*params(1)-T508*T21*params(1))/(T21*T21)));
  g1(49,19)=(-((T21*params(1)*exp(y(19))*T507-T21*params(1)*exp(y(19))*T507)/(T21*T21)));
  g1(49,22)=T39;
  g1(50,1)=(-(T39*exp(y(1))*exp(y(11))));
  g1(50,11)=T312;
  g1(50,13)=1-T39*(1-exp(y(11)));
  g1(50,22)=T625;
  g1(51,13)=(-params(7));
  g1(51,14)=1-T39*(1-params(7));
  g1(51,22)=(-(y(14)*T39*(1-params(7))));
  g1(52,3)=y(14)*T115*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(52,14)=T115*params(4)*exp(y(3)*(params(4)-1));
  g1(53,1)=(-(exp(y(1))*T39));
  g1(53,11)=T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(53,13)=T39;
  g1(53,22)=T610;
  g1(54,1)=(-(T39*exp(y(1))*exp(y(29))));
  g1(54,22)=T646;
  g1(54,29)=T816;
  g1(54,30)=1-T39*(1-exp(y(29)));
  g1(55,22)=(-(y(31)*T39*(1-params(23))));
  g1(55,30)=(-params(23));
  g1(55,31)=1-T39*(1-params(23));
  g1(56,25)=y(31)*T729*params(4)*(params(4)-1)*exp(y(25)*(params(4)-1));
  g1(56,31)=T729*params(4)*exp(y(25)*(params(4)-1));
  g1(57,1)=(-exp(y(1)));
  g1(57,29)=params(22)*params(21)*(params(21)-1)*exp(y(29)*(params(21)-1));
  g1(57,30)=1;
  g1(58,7)=exp(y(7))-exp(y(7))*(1-exp(y(11)));
  g1(58,9)=(-(params(7)*exp(y(9))));
  g1(58,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(59,27)=exp(y(27))-(1-exp(y(29)))*exp(y(27));
  g1(59,28)=(-(params(23)*exp(y(28))));
  g1(59,29)=(-(exp(y(27))*(-exp(y(29)))));
  g1(60,6)=exp(y(6))-exp(y(6))*(1-exp((-y(24)))*exp(y(10)));
  g1(60,8)=(-(exp(y(8))*params(7)));
  g1(60,10)=(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(60,24)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(61,3)=(-(T115*params(4)*exp(y(3)*params(4))));
  g1(61,9)=exp(y(9))-(1-params(7))*exp(y(9));
  g1(62,25)=(-(T729*params(4)*exp(y(25)*params(4))));
  g1(62,28)=exp(y(28))-(1-params(23))*exp(y(28));
  g1(63,2)=(-(T89*params(4)*exp(y(2)*params(4))));
  g1(63,8)=exp(y(8))-exp(y(8))*(1-params(7));
  g1(64,5)=exp(y(5));
  g1(64,7)=(-(exp(y(11))*exp(y(7))));
  g1(64,11)=(-(exp(y(11))*exp(y(7))));
  g1(65,26)=exp(y(26));
  g1(65,27)=(-(exp(y(29))*exp(y(27))));
  g1(65,29)=(-(exp(y(29))*exp(y(27))));
  g1(66,4)=exp(y(4));
  g1(66,6)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(66,10)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(66,24)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(67,4)=(-exp(y(4)));
  g1(67,5)=(-exp(y(5)));
  g1(67,15)=exp(y(15));
  g1(67,26)=(-exp(y(26)));
  g1(68,24)=1;
  g1(69,23)=1-(params(15)+params(16));
  g1(70,10)=(-exp(y(10)));
  g1(70,38)=exp(y(38));
  g1(71,32)=1;
  g1(72,33)=1;
  g1(73,34)=1;
  g1(74,35)=1;
  g1(75,36)=1;
  g1(76,37)=1;
  g1(77,39)=1;
  g1(78,40)=1;
  g1(79,69)=(-1);
  g1(79,79)=1;
  g1(80,23)=(-1);
  g1(80,80)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],80,6400);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],80,512000);
end
end
end
end
